import 'prismjs/components/prism-mermaid.min.js';
import type { DesignConfig } from '../../src/types/designConfig';
import type { TodoItem } from '../../src/types/todoItem';
export type PlanStatus = 'prepare' | 'ready' | 'building' | 'finished';
declare global {
    interface Window {
        initialMarkdown?: string;
        initialTodoList?: TodoItem[];
        initialDesignConfig?: DesignConfig | null;
        fileName?: string;
        planStatus?: PlanStatus;
        conversationId: string;
        planName: string;
        planHasConfirmed: boolean;
        planOverview: string;
        scrollToPart?: 'todolist' | 'design' | null;
        initialDiffStats?: {
            additions: number;
            deletions: number;
            totalChanges: number;
        } | null;
        initialDiffChanges?: DiffChange[] | null;
        parts: Array<'req' | 'tech' | 'design' | 'extensions' | 'todos'>;
    }
}
interface DiffChange {
    count?: number;
    value: string;
    added?: boolean;
    removed?: boolean;
}
export {};
//# sourceMappingURL=index.d.ts.map